using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;
using RackTable = gov.va.med.vbecs.Common.VbecsTables.Rack;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectTestingRack
	/// </summary>
	public class DlgSelectTestingRack : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Form Controls
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpRack;
		private System.Windows.Forms.ListView lvRacks;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.GroupBox grpRackDate;
		private System.Windows.Forms.DateTimePicker dtpDateTested;
		private System.Windows.Forms.Label lblDateTested;
		private System.Windows.Forms.GroupBox grpAutomatedInstrument;
		private System.Windows.Forms.TextBox txtInstrumentName;
		private System.Windows.Forms.Label lblInstrumentName;
		private System.Windows.Forms.CheckBox cbInstrumentQCd;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbTestedBy;
		private System.Windows.Forms.Label lblTestedBy;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.CheckBox cbAutomatedInstrument;

		#endregion

		#region Variables
		bool _calledSelectionFromCheck = false;
		private ArrayList _orderedTests = new ArrayList();
		private ArrayList _orderedComponents = new ArrayList();
		private ArrayList _users;
		/// <summary>
		/// Current date value based on the division time zone
		/// </summary>
		private System.DateTime _currentDate;
		private System.Windows.Forms.Panel pnlRackPhaseAuto;
		private System.Windows.Forms.GroupBox grpTestingPhases;
		private System.Windows.Forms.RadioButton rdoAHG;
		private System.Windows.Forms.RadioButton rdoAllPhases;
		private bool _isLoading = false;
		ArrayList _expiredOrderExceptions;

		#endregion

		#region Constructors / Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="orderedTests"></param>
		/// <param name="mdiParent"></param>
		/// <param name="expiredOrderExceptions"></param>
		public DlgSelectTestingRack(ArrayList orderedTests, System.Windows.Forms.Form mdiParent, ArrayList expiredOrderExceptions)
		{
			// This call is required by the Windows Form Designer.
			this._isLoading = true;

			InitializeComponent();
			this._orderedTests = orderedTests;
			this._orderedComponents = new ArrayList();
			this._expiredOrderExceptions = expiredOrderExceptions;
			SetComponentProperties();

            //CR 3523
            this.LockController.LockFunction = Common.LockFunctions.UC092PendingTaskList;
            foreach (BOL.OrderedTest test in orderedTests)
            {
                this.LockController.RecordGuids.Add(test.OrderedTestGuid);
            }
            if (!this.SetLocks())
            {
                this.DialogResult = DialogResult.Abort;
                return;
            }

			this._isLoading = false;
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="orderedTests"></param>
		/// <param name="orderedComponents"></param>
		/// <param name="mdiParent"></param>
		/// <param name="expiredOrderExceptions"></param>
		public DlgSelectTestingRack(ArrayList orderedTests, ArrayList orderedComponents, System.Windows.Forms.Form mdiParent, ArrayList expiredOrderExceptions)
		{
			// The OrderedComponents ArrayList holds components that have units associated with them that 
			// require a crossmatch.

			// This call is required by the Windows Form Designer.
			this._isLoading = true;
			InitializeComponent();
			this._orderedTests = orderedTests;
			this._orderedComponents = orderedComponents;
			this._expiredOrderExceptions = expiredOrderExceptions;
			SetComponentProperties();

            //CR 3523
            this.LockController.LockFunction = Common.LockFunctions.UC092PendingTaskList;
            foreach (BOL.OrderedTest test in orderedTests)
            {
                this.LockController.RecordGuids.Add(test.OrderedTestGuid);
            }
            if (!this.SetLocks())
            {
                this.DialogResult = DialogResult.Abort;
                return;
            }

			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(DlgSelectTestingRack));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpRack = new System.Windows.Forms.GroupBox();
            this.lvRacks = new System.Windows.Forms.ListView();
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpTestingPhases = new System.Windows.Forms.GroupBox();
            this.rdoAHG = new System.Windows.Forms.RadioButton();
            this.rdoAllPhases = new System.Windows.Forms.RadioButton();
            this.grpAutomatedInstrument = new System.Windows.Forms.GroupBox();
            this.cbInstrumentQCd = new System.Windows.Forms.CheckBox();
            this.txtInstrumentName = new System.Windows.Forms.TextBox();
            this.lblInstrumentName = new System.Windows.Forms.Label();
            this.grpRackDate = new System.Windows.Forms.GroupBox();
            this.cmbTestedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblTestedBy = new System.Windows.Forms.Label();
            this.dtpDateTested = new System.Windows.Forms.DateTimePicker();
            this.lblDateTested = new System.Windows.Forms.Label();
            this.cbAutomatedInstrument = new System.Windows.Forms.CheckBox();
            this.pnlRackPhaseAuto = new System.Windows.Forms.Panel();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpRack.SuspendLayout();
            this.grpTestingPhases.SuspendLayout();
            this.grpAutomatedInstrument.SuspendLayout();
            this.grpRackDate.SuspendLayout();
            this.pnlRackPhaseAuto.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(442, 30);
            this.vbecsLogo1.Title = "Testing Details";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 267);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 212);
            this.grpImage.TabIndex = 9;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(362, 249);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 4;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(282, 249);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 3;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // grpRack
            // 
            this.grpRack.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpRack.Controls.Add(this.lvRacks);
            this.grpRack.Location = new System.Drawing.Point(0, 4);
            this.grpRack.Name = "grpRack";
            this.grpRack.Size = new System.Drawing.Size(168, 144);
            this.grpRack.TabIndex = 0;
            this.grpRack.TabStop = false;
            this.grpRack.Text = "Reagent Rack*";
            // 
            // lvRacks
            // 
            this.lvRacks.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvRacks.CheckBoxes = true;
            this.lvRacks.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader3,
            this.columnHeader1,
            this.columnHeader2});
            this.lvRacks.FullRowSelect = true;
            this.lvRacks.Location = new System.Drawing.Point(8, 16);
            this.lvRacks.MultiSelect = false;
            this.lvRacks.Name = "lvRacks";
            this.lvRacks.Size = new System.Drawing.Size(152, 120);
            this.lvRacks.TabIndex = 0;
            this.lvRacks.UseCompatibleStateImageBehavior = false;
            this.lvRacks.View = System.Windows.Forms.View.Details;
            this.lvRacks.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvRacks_ItemCheck);
            this.lvRacks.SelectedIndexChanged += new System.EventHandler(this.lvRacks_SelectedIndexChanged);
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "";
            this.columnHeader3.Width = 25;
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Rack";
            this.columnHeader1.Width = 40;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Tested";
            this.columnHeader2.Width = 80;
            // 
            // grpTestingPhases
            // 
            this.grpTestingPhases.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpTestingPhases.Controls.Add(this.rdoAHG);
            this.grpTestingPhases.Controls.Add(this.rdoAllPhases);
            this.grpTestingPhases.Location = new System.Drawing.Point(172, 4);
            this.grpTestingPhases.Name = "grpTestingPhases";
            this.grpTestingPhases.Size = new System.Drawing.Size(204, 60);
            this.grpTestingPhases.TabIndex = 2;
            this.grpTestingPhases.TabStop = false;
            this.grpTestingPhases.Text = "ABS or XM Testing Phases*";
            // 
            // rdoAHG
            // 
            this.rdoAHG.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rdoAHG.Location = new System.Drawing.Point(16, 36);
            this.rdoAHG.Name = "rdoAHG";
            this.rdoAHG.Size = new System.Drawing.Size(175, 20);
            this.rdoAHG.TabIndex = 1;
            this.rdoAHG.Text = "&AHG Only";
            this.rdoAHG.CheckedChanged += new System.EventHandler(this.rdoAHG_CheckedChanged);
            // 
            // rdoAllPhases
            // 
            this.rdoAllPhases.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rdoAllPhases.Checked = true;
            this.rdoAllPhases.Location = new System.Drawing.Point(16, 16);
            this.rdoAllPhases.Name = "rdoAllPhases";
            this.rdoAllPhases.Size = new System.Drawing.Size(175, 20);
            this.rdoAllPhases.TabIndex = 0;
            this.rdoAllPhases.TabStop = true;
            this.rdoAllPhases.Text = "All &Phases";
            this.rdoAllPhases.CheckedChanged += new System.EventHandler(this.rdoAllPhases_CheckedChanged);
            // 
            // grpAutomatedInstrument
            // 
            this.grpAutomatedInstrument.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.grpAutomatedInstrument.Controls.Add(this.cbInstrumentQCd);
            this.grpAutomatedInstrument.Controls.Add(this.txtInstrumentName);
            this.grpAutomatedInstrument.Controls.Add(this.lblInstrumentName);
            this.grpAutomatedInstrument.Enabled = false;
            this.grpAutomatedInstrument.Location = new System.Drawing.Point(172, 68);
            this.grpAutomatedInstrument.Name = "grpAutomatedInstrument";
            this.grpAutomatedInstrument.Size = new System.Drawing.Size(204, 80);
            this.grpAutomatedInstrument.TabIndex = 4;
            this.grpAutomatedInstrument.TabStop = false;
            // 
            // cbInstrumentQCd
            // 
            this.cbInstrumentQCd.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbInstrumentQCd.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbInstrumentQCd.Location = new System.Drawing.Point(8, 56);
            this.cbInstrumentQCd.Name = "cbInstrumentQCd";
            this.cbInstrumentQCd.Size = new System.Drawing.Size(189, 20);
            this.cbInstrumentQCd.TabIndex = 1;
            this.cbInstrumentQCd.Text = "Instrument &QC\'d?";
            this.cbInstrumentQCd.CheckedChanged += new System.EventHandler(this.cbInstrumentQCd_CheckedChanged);
            // 
            // txtInstrumentName
            // 
            this.txtInstrumentName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtInstrumentName.Location = new System.Drawing.Point(8, 32);
            this.txtInstrumentName.MaxLength = 50;
            this.txtInstrumentName.Name = "txtInstrumentName";
            this.txtInstrumentName.Size = new System.Drawing.Size(189, 20);
            this.txtInstrumentName.TabIndex = 0;
            this.txtInstrumentName.TextChanged += new System.EventHandler(this.txtInstrumentName_TextChanged);
            // 
            // lblInstrumentName
            // 
            this.lblInstrumentName.Location = new System.Drawing.Point(8, 16);
            this.lblInstrumentName.Name = "lblInstrumentName";
            this.lblInstrumentName.Size = new System.Drawing.Size(100, 20);
            this.lblInstrumentName.TabIndex = 11;
            this.lblInstrumentName.Text = "Instrument Name*";
            this.lblInstrumentName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpRackDate
            // 
            this.grpRackDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpRackDate.Controls.Add(this.cmbTestedBy);
            this.grpRackDate.Controls.Add(this.lblTestedBy);
            this.grpRackDate.Controls.Add(this.dtpDateTested);
            this.grpRackDate.Controls.Add(this.lblDateTested);
            this.grpRackDate.Location = new System.Drawing.Point(60, 32);
            this.grpRackDate.Name = "grpRackDate";
            this.grpRackDate.Size = new System.Drawing.Size(376, 64);
            this.grpRackDate.TabIndex = 1;
            this.grpRackDate.TabStop = false;
            // 
            // cmbTestedBy
            // 
            this.cmbTestedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbTestedBy.Interval = 100;
            this.cmbTestedBy.Location = new System.Drawing.Point(80, 36);
            this.cmbTestedBy.MaxLength = 50;
            this.cmbTestedBy.Name = "cmbTestedBy";
            this.cmbTestedBy.Size = new System.Drawing.Size(288, 22);
            this.cmbTestedBy.TabIndex = 1;
            this.cmbTestedBy.SelectedIndexChanged += new System.EventHandler(this.cmbTestedBy_SelectedIndexChanged);
            this.cmbTestedBy.TextChanged += new System.EventHandler(this.cmbTestedBy_TextChanged);
            this.cmbTestedBy.Leave += new System.EventHandler(this.cmbTestedBy_Leave);
            // 
            // lblTestedBy
            // 
            this.lblTestedBy.Location = new System.Drawing.Point(8, 36);
            this.lblTestedBy.Name = "lblTestedBy";
            this.lblTestedBy.Size = new System.Drawing.Size(64, 20);
            this.lblTestedBy.TabIndex = 5;
            this.lblTestedBy.Text = "Tested By*";
            this.lblTestedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // dtpDateTested
            // 
            this.dtpDateTested.CustomFormat = "MM/dd/yyyy HH:mm";
            this.dtpDateTested.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpDateTested.Location = new System.Drawing.Point(80, 12);
            this.dtpDateTested.Name = "dtpDateTested";
            this.dtpDateTested.Size = new System.Drawing.Size(128, 20);
            this.dtpDateTested.TabIndex = 0;
            this.dtpDateTested.ValueChanged += new System.EventHandler(this.dtpDateTested_ValueChanged);
            // 
            // lblDateTested
            // 
            this.lblDateTested.Location = new System.Drawing.Point(8, 12);
            this.lblDateTested.Name = "lblDateTested";
            this.lblDateTested.Size = new System.Drawing.Size(72, 20);
            this.lblDateTested.TabIndex = 2;
            this.lblDateTested.Text = "Date Tested*";
            this.lblDateTested.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cbAutomatedInstrument
            // 
            this.cbAutomatedInstrument.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.cbAutomatedInstrument.Location = new System.Drawing.Point(176, 68);
            this.cbAutomatedInstrument.Name = "cbAutomatedInstrument";
            this.cbAutomatedInstrument.Size = new System.Drawing.Size(172, 16);
            this.cbAutomatedInstrument.TabIndex = 12;
            this.cbAutomatedInstrument.Text = "&Using Automated Instrument";
            this.cbAutomatedInstrument.CheckedChanged += new System.EventHandler(this.cbAutomatedInstrument_CheckedChanged);
            // 
            // pnlRackPhaseAuto
            // 
            this.pnlRackPhaseAuto.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlRackPhaseAuto.Controls.Add(this.cbAutomatedInstrument);
            this.pnlRackPhaseAuto.Controls.Add(this.grpRack);
            this.pnlRackPhaseAuto.Controls.Add(this.grpTestingPhases);
            this.pnlRackPhaseAuto.Controls.Add(this.grpAutomatedInstrument);
            this.pnlRackPhaseAuto.Location = new System.Drawing.Point(60, 96);
            this.pnlRackPhaseAuto.Name = "pnlRackPhaseAuto";
            this.pnlRackPhaseAuto.Size = new System.Drawing.Size(378, 148);
            this.pnlRackPhaseAuto.TabIndex = 13;
            // 
            // DlgSelectTestingRack
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(442, 281);
            this.Controls.Add(this.pnlRackPhaseAuto);
            this.Controls.Add(this.grpRackDate);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.hlphelpChm.SetHelpKeyword(this, "Patient_Testing_General_Instructions.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(420, 308);
            this.Name = "DlgSelectTestingRack";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Testing Details";
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.DlgSelectTestingRack_FormClosing);
            this.Load += new System.EventHandler(this.DlgSelectTestingRack_Load);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.grpRackDate, 0);
            this.Controls.SetChildIndex(this.pnlRackPhaseAuto, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpRack.ResumeLayout(false);
            this.grpTestingPhases.ResumeLayout(false);
            this.grpAutomatedInstrument.ResumeLayout(false);
            this.grpAutomatedInstrument.PerformLayout();
            this.grpRackDate.ResumeLayout(false);
            this.pnlRackPhaseAuto.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void DlgSelectTestingRack_Load(object sender, System.EventArgs e)
		{
			if (this.pnlRackPhaseAuto.Enabled == true)
			{
				LoadRackList();
			}

			LoadUserList();
			CheckForRequiredData();
		}

		/// <summary>
		/// BR_56.07
		/// </summary>
		private void LoadRackList()
		{
			this.lvRacks.Items.Clear();

			DataTable dtRacks = BOL.Rack.GetDailyQCRacks(this.dtpDateTested.Value);

			foreach(DataRow drRack in dtRacks.Rows)
			{
				if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false)
				{
					if( !(bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] )
						continue;
				}

				ListViewItem lvItm = new ListViewItem();
				lvItm.SubItems.Add( drRack[ RackTable.RackName ].ToString().Trim() );
				
				if( !drRack.IsNull( Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate ))
				{
					if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator] == false)
						lvItm.SubItems.Add("Yes");
					else
						lvItm.SubItems.Add("No");
				}
				else
				{
					lvItm.SubItems.Add("No");
				}

				lvItm.Tag = drRack;
				this.lvRacks.Items.Add( lvItm );
			}
		}

		private void LoadUserList()
		{
			cmbTestedBy.SelectedIndex = -1;
			cmbTestedBy.Items.Clear();
			
			foreach( BOL.VbecsUser _user in (this._users = BOL.VbecsUser.GetActiveDivisionUsers( LogonUser.LogonUserDivisionCode )) )
				this.cmbTestedBy.Items.Add( _user.UserName );

			this.cmbTestedBy.SelectedItem = ThisUser.UserName;
		}

		/// <summary>
		/// Checks if the user entered all required data
		/// </summary>
		/// <returns></returns>
		private bool CheckForRequiredData()
		{
			string ToolTipMessage = "";

			if (this.pnlRackPhaseAuto.Enabled == true)
			{
				if (this.lvRacks.SelectedItems.Count == 0)
				{
					ToolTipMessage += Common.StrRes.Tooltips.UC056.ChooseRack().ResString;
					ToolTipMessage += "\n";
				}

				if ( this.cbAutomatedInstrument.Checked && (this.txtInstrumentName.Text.Trim() == ""))// || !this.cbInstrumentQCd.Checked ))
				{
					ToolTipMessage += Common.StrRes.Tooltips.UC056.EnterAutoInstrument().ResString;
					ToolTipMessage += "\n";
				}
			}

			if (this.cmbTestedBy.Text.Trim() == "" ||
				this.cmbTestedBy.SelectedIndex == -1)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.ChooseTestedBy().ResString;
				ToolTipMessage += "\n";
			}

			this.btnOK.SetToolTip(ToolTipMessage);

			return ( ToolTipMessage == "" );
		}

		private void lvRacks_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.NewValue == CheckState.Checked)
			{
				foreach( ListViewItem lvi in this.lvRacks.CheckedItems )
					lvi.Checked = false;

				_calledSelectionFromCheck = true;
				this.lvRacks.Items[e.Index].Selected = true;
			}
			else
			{
				_calledSelectionFromCheck = true;
				this.lvRacks.Items[e.Index].Selected = false;
			}
			UpdateOkButtonState();

		}

		private void lvRacks_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!_calledSelectionFromCheck)
			{
				foreach( ListViewItem lvi in ((ListView)sender).SelectedItems )
					lvi.Checked = true;
			}
			else
			{
				_calledSelectionFromCheck = false;
			}
		}

		private void dtpDateTested_ValueChanged(object sender, System.EventArgs e)
		{
			if( this._isLoading ) 
				return;

			if (this.dtpDateTested.Value > _currentDate)
				this.dtpDateTested.Value = _currentDate;

			if (this.pnlRackPhaseAuto.Enabled == true)
			{
				LoadRackList();
			}

			UpdateOkButtonState();
		}

		private void cbAutomatedInstrument_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpAutomatedInstrument.Enabled = ((CheckBox)sender).Checked;

			UpdateOkButtonState();
		}

		private void cmbTestedBy_Leave(object sender, System.EventArgs e)
		{
			UpdateOkButtonState();
			if (cmbTestedBy.SelectedIndex != -1)
				FocusOnCmbTestedByAndUpdateOkButtonState();
			else
				return;
		}

		private void cmbTestedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbTestedBy.SelectedIndex != -1)
				FocusOnCmbTestedByAndUpdateOkButtonState();
			else
				return;
		}

		private void FocusOnCmbTestedByAndUpdateOkButtonState()
		{
			int i;

			for( i = 0; i < this.cmbTestedBy.Items.Count; i++ )
				if( this.cmbTestedBy.Items[i].ToString() == this.cmbTestedBy.Text.Trim() )
					break;

			if( i == this.cmbTestedBy.Items.Count )
				this.cmbTestedBy.Focus();

			UpdateOkButtonState();
		}

		private void txtInstrumentName_TextChanged(object sender, System.EventArgs e)
		{
			UpdateOkButtonState();
		}

		private void cmbTestedBy_TextChanged(object sender, System.EventArgs e)
		{
			UpdateOkButtonState();
		}

		private void cbInstrumentQCd_CheckedChanged(object sender, System.EventArgs e)
		{
			UpdateOkButtonState();
		}

		private void UpdateOkButtonState()
		{
			this.btnOK.EnabledButton = CheckForRequiredData();
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DataRow drRack = null;
			DateTime testDateTime;
			Common.ReactivityPhase reactivityPhase = Common.ReactivityPhase.All;
			string automatedInstrName = "";
			bool automatedInstrQCd = true;
			ArrayList rackNotTestedExceptions = new ArrayList();
			bool qcOffline = false;

			if (this.pnlRackPhaseAuto.Enabled == true)
			{
				foreach( ListViewItem lvItm in this.lvRacks.CheckedItems )
					drRack = (DataRow)lvItm.Tag;

                //CR 3554
                if (drRack == null)
                    throw new ApplicationException("Rack is not found"); //Carrie123

				//CR 2718 - skip check for BR_41.30 if QC was done Offline
				if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == true)
						qcOffline = true;
				}

				if (qcOffline == false)
				{
					//BR_41.30
					DataTable dt = BOL.Reagent.GetReagentFromRack((Guid)drRack[Common.VbecsTables.Rack.RackGuid],(int)Common.ReagentType.AntiA, Common.LogonUser.LogonUserDivisionCode);
					if (dt.Rows.Count == 0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(Common.StrRes.Tooltips.Common.RackNotConfigured().ResString));
						return;
					}
				}

				bool RackNotTested = drRack.IsNull( Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate ) || ((bool)drRack[Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator] == true);

				//BR_56.07
				if( RackNotTested )
				{
					DlgOverrideComment dlg = new DlgOverrideComment( "QC not performed", "Rack QC not performed. Continue to use?", "PT" );

					if( dlg.ShowDialog(this) == DialogResult.Cancel )
						return;

					string	rackName = drRack[RackTable.RackName].ToString(),
						overrideComment = dlg.Comment;

					foreach( BOL.OrderedTest test in this._orderedTests )
						CheckForExceptionsAddReportIfNeeded( test.Patient, test.Specimen, rackName, overrideComment, rackNotTestedExceptions );

					foreach( BOL.OrderedComponent componentOrder in this._orderedComponents )
						CheckForExceptionsAddReportIfNeeded( componentOrder.Patient, componentOrder.GetSpecimen(), rackName, overrideComment, rackNotTestedExceptions );  // CR3114
				}

				if (this.cbAutomatedInstrument.Checked)
				{
					automatedInstrName = this.txtInstrumentName.Text.Trim();
				}

				automatedInstrQCd = this.cbInstrumentQCd.Checked;
			}
			else
			{
				drRack = new DataTable().NewRow();
			}

			testDateTime = this.dtpDateTested.Value;

			//CR 2805 removed code checking if panel is enabled
			if (this.rdoAHG.Checked)
				reactivityPhase = Common.ReactivityPhase.IAT;
			else if (this.rdoAllPhases.Checked)
				reactivityPhase = Common.ReactivityPhase.All;

			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
                //CR 3523
                if (this.LockController.RecordGuids.Count > 0)
                {
                    this.ReleaseLocks();
                }

				FrmRecordTesting frm = new FrmRecordTesting(this._orderedTests, this._orderedComponents, drRack, ((BOL.VbecsUser)this._users[this.cmbTestedBy.SelectedIndex]).UserNTLoginID, testDateTime, reactivityPhase, automatedInstrName, automatedInstrQCd, rackNotTestedExceptions, this._expiredOrderExceptions);

				if( !frm.FormClosed )
				{
					frm.MdiParent = this.MdiParent;
					frm.Show();
				}
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}

			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void CheckForExceptionsAddReportIfNeeded( BOL.Patient patient, BOL.Specimen specimen, string rackName, string overrideComment, ArrayList rackNotTestedExceptions )
		{			
			if(this.CheckForExistingExceptions( patient, specimen, rackNotTestedExceptions ) )
				return;

			BOL.ExceptionReport exRep = new BOL.ExceptionReport( Common.ExceptionType.QC_not_performed_on_rack_used_for_testing, overrideComment, Common.LogonUser.LogonUserName);
			exRep.GenerateExceptionQCNotPerformed( patient, specimen, rackName, (string)this.cmbTestedBy.SelectedItem );
			rackNotTestedExceptions.Add( exRep );
		}

		private bool CheckForExistingExceptions(BOL.Patient patient, BOL.Specimen specimen, ArrayList exceptions)
		{
			foreach(BOL.ExceptionReport exception in exceptions)
			{
				if (exception.ExceptionData[Common.VbecsTables.ExceptionQcNotPerformed.PatientName].ToString().Trim() == String.Concat( patient.LastName, ", ", patient.FirstName ) &&
					exception.ExceptionData[Common.VbecsTables.ExceptionQcNotPerformed.PatientId].ToString().Trim() == patient.DisplayPatientID &&
					exception.ExceptionData[Common.VbecsTables.ExceptionQcNotPerformed.SpecimenUid].ToString().Trim() == specimen.SpecimenUid)
					return true;
			}

			return false;
		}

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC056.DlgSelectTestingRack());
			//
			//set custom date and time format
			this.dtpDateTested.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpDateTested.Value = _currentDate;

			//CR 2805
			Common.ReactivityPhase reactivityPhase = Common.ReactivityPhase.Unknown;
			bool atLeastOneNotStarted = false;
			bool ABSorXM = false;

			if (ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator == true)
			{
				foreach(BOL.OrderedTest orderedTest in this._orderedTests)
				{
					//CR 2805
					if (orderedTest.TaskStatusCode != Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
					{
						atLeastOneNotStarted = true;
					}

					if (orderedTest.OrderableTest.Trim() == "ABS" ||
						orderedTest.OrderableTest.Trim() == "Repeat ABS" ||
						orderedTest.OrderableTest.Trim() == "TAS" ||
						orderedTest.OrderableTest.Trim() == "Repeat XM")
					{
						ABSorXM = true;
						//CR 2805 if test is partially completed obtain the reactivity phase code from existing test results
						if (orderedTest.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) &&
							reactivityPhase == Common.ReactivityPhase.Unknown)
						{
							DataTable dtTestResults = BOL.OrderedTest.GetTestResultsForTask(orderedTest.OrderedTestGuid);
							for (int i=0;i<dtTestResults.Rows.Count;i++)
							{
								if (dtTestResults.Rows[i].IsNull(Common.VbecsTables.SpecimenTest.ReactivityPhaseCode) == false)
								{
									reactivityPhase = Common.Utility.GetReactivityPhaseCodeFromChar(Convert.ToChar(dtTestResults.Rows[i][Common.VbecsTables.SpecimenTest.ReactivityPhaseCode]));
								}
								if (reactivityPhase != Common.ReactivityPhase.Unknown)
									break;
							}
						}
					}
				}

				foreach(BOL.OrderedComponent orderedComponent in this._orderedComponents)
				{
					DataTable dtBloodUnitTests = BOL.BloodUnitTest.GetTestResultsForXM(Guid.Empty, orderedComponent.OrderedComponentGuid);
					DataTable dtOrderedUnits = BOL.OrderedUnit.GetOrderedUnitsForRepeatXM(Guid.Empty, orderedComponent.OrderedComponentGuid);
					foreach(DataRow drOrderedUnit in dtOrderedUnits.Rows)
					{
						if ((bool)drOrderedUnit[Common.VbecsTables.OrderedUnit.CrossmatchRequiredIndicator] == true)
						{
							ABSorXM = true;
						}

						DataRow[] testResultsForUnit = dtBloodUnitTests.Select(Common.VbecsTables.OrderedUnit.OrderedUnitGuid + " = '" + drOrderedUnit[Common.VbecsTables.OrderedUnit.OrderedUnitGuid].ToString() + "'");
						//CR 2805 if test is partially completed obtain the reactivity phase code from existing test results
						if (testResultsForUnit.Length == 0)
							atLeastOneNotStarted = true;

						if (reactivityPhase == Common.ReactivityPhase.Unknown)
						{
							foreach(DataRow testResult in testResultsForUnit)
							{
								if (testResult.IsNull(Common.VbecsTables.BloodUnitTest.ReactivityPhaseCode) == false)
									reactivityPhase = Common.Utility.GetReactivityPhaseCodeFromChar(Convert.ToChar(testResult[Common.VbecsTables.BloodUnitTest.ReactivityPhaseCode]));
							}
						}
					}
				}

				//CR 2805 for partially completed tests set the reactivity phase code based on their saved results
				this.pnlRackPhaseAuto.Enabled = atLeastOneNotStarted;

				if (ABSorXM == true)
				{
					if (reactivityPhase == Common.ReactivityPhase.Unknown)
					{
						//CR 2717
						BOL.Division currentDivision = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
						if (currentDivision.ReactivityPhaseCode == Common.ReactivityPhase.All)
							this.rdoAllPhases.Checked = true;
						else
							this.rdoAHG.Checked = true;
						this.grpTestingPhases.Enabled = true;
					}
					else
					{
						if (reactivityPhase == Common.ReactivityPhase.All)
							this.rdoAllPhases.Checked = true;
						else
							this.rdoAHG.Checked = true;
						this.grpTestingPhases.Enabled = false;
					}
				}
				else
				{
					this.grpTestingPhases.Enabled = false;
				}


			}
			else
			{
				this.pnlRackPhaseAuto.Enabled = false;
			}

		}

		private void rdoAllPhases_CheckedChanged(object sender, System.EventArgs e)
		{
			UpdateOkButtonState();
		}

		private void rdoAHG_CheckedChanged(object sender, System.EventArgs e)
		{
			UpdateOkButtonState();
		}

        //CR 3523 cleaning locks
        private void DlgSelectTestingRack_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.LockController.RecordGuids.Count > 0)
            {
                this.ReleaseLocks();
            }
        }
    }
}